<?php
function dt_enqueue_styles() {
    $parenthandle = 'divi-style'; 
    $theme = wp_get_theme();
    wp_enqueue_style( $parenthandle, get_template_directory_uri() . '/style.css', 
        array(), // if the parent theme code has a dependency, copy it to here
        $theme->parent()->get('Version')
    );
    wp_enqueue_style( 'child-style', get_stylesheet_uri(),
        array( $parenthandle ),
        $theme->get('Version') 
    );
}
add_action( 'wp_enqueue_scripts', 'dt_enqueue_styles' );


function courses_by_category($atts) {
  $atts = shortcode_atts(
      array(
          'category' => '',
      ), $atts, 'courses'
  );

  $args = array(
      'post_type' => 'courses',
      'posts_per_page' => -1,
      'meta_key' => 'start_course_date',
      'orderby' => 'meta_value',
      'order' => 'ASC',
      'meta_query' => array(
          array(
              'key' => 'category',
              'value' => $atts['category'],
              'compare' => '=',
          )
      )
  );

  $query = new WP_Query($args);

  if ($query->have_posts()) {
      $output = '';
      $output .= '<div class="course-table">';
      while ($query->have_posts()) {
          $query->the_post();

          $start_date_raw = get_field('start_course_date');
          $end_date_raw = get_field('end_course_date');
          $current_date = current_time('Y-m-d');

          // Format the date range
          $start_date = DateTime::createFromFormat('Y-m-d', $start_date_raw);
          $end_date = DateTime::createFromFormat('Y-m-d', $end_date_raw);

          if ($start_date && $end_date) {
              if ($start_date->format('F') === $end_date->format('F')) {
                  $course_date_formatted = $start_date->format('j') . '-' . $end_date->format('j') . ' ' . strtolower(date_i18n('F', strtotime($start_date_raw))) . ' ' . $end_date->format('Y');
              } else {
                  $course_date_formatted = $start_date->format('j ') . strtolower(date_i18n('F', strtotime($start_date_raw))) .
                      ' - ' . $end_date->format('j ') . strtolower(date_i18n('F', strtotime($end_date_raw))) . ' ' . $end_date->format('Y');
              }
          } else {
              $course_date_formatted = 'Data indisponibilă';
          }

          $course_title = get_the_title();
          $course_title_encoded = urlencode($course_title);

          $output .= '<div class="course-row">';
          $output .= '<div class="course-column course-region">' . get_field('region') . '</div>';
          $output .= '<div class="course-column course-city">' . get_field('city') . '</div>';
          $output .= '<div class="course-column course-date">' . $course_date_formatted . '</div>';
          $output .= '<div class="course-column course-location">' . get_field('location') . '</div>';

          if ($current_date <= $end_date_raw) {
              $output .= '<div class="course-column course-button"><a href="/inscrieri?course_title=' . $course_title_encoded . '" class="register-button">Înscrie-te</a></div>';
          } else {
              $output .= '<div class="course-column course-button"><span class="closed-button">Curs încheiat</span></div>';
          }

          $output .= '</div>'; // End course-row
      }
      wp_reset_postdata();
      $output .= '</div>'; // End course-table
      return $output;
  } else {
      return '<p>No courses found.</p>';
  }
}


add_shortcode('courses', 'courses_by_category');

function acf_title_courses( $value, $post_id, $field ) {
    if ( get_post_type( $post_id ) === 'courses' ) {

        if ( !empty($value) ) {
            wp_update_post( array(
                'ID'         => $post_id,
                'post_title' => $value
            ) );
        }
    }
    return $value;
}

add_filter( 'acf/update_value/name=region', 'acf_title_courses', 10, 3 );
function dynamic_sessions_field_values($scanned_tag, $replace) {
  if ($scanned_tag['name'] !== 'session') {
    return $scanned_tag;
  }

  $course_title = isset($_GET['course_title']) ? sanitize_text_field($_GET['course_title']) : '';
  $sessions = get_posts([
    'post_type' => 'courses',
    'fields' => 'ids',
    'numberposts' => -1,
    'orderby' => 'title',
    'order' => 'ASC'
  ]);

  if (!$sessions) {
    return $scanned_tag;
  }

  $options = [];
  $selected_value = '';

  foreach ($sessions as $id) {
    $title = get_the_title($id);
    $options[] = $title . '|' . $title;

    if ($course_title && strtolower($title) === strtolower($course_title)) {
      $selected_value = $title;
    }
  }

  $scanned_tag['raw_values'] = $options;
  $scanned_tag['labels'] = $options;

  if ($selected_value) {
    // Pre-select logic handled here for Contact Form 7
    $scanned_tag['values'] = [$selected_value];

    // Inject script safely in footer
    add_action('wp_footer', function () use ($selected_value) {
      ?>
      <script>
      document.addEventListener("DOMContentLoaded", function() {
          var select = document.querySelector("[name='session']");
          if (select) {
              select.value = "<?php echo esc_js($selected_value); ?>";
          }
      });
      </script>
      <?php
    });
  }

  $pipes = new WPCF7_Pipes($scanned_tag['raw_values']);
  $scanned_tag['values'] = $pipes->collect_befores();
  $scanned_tag['labels'] = $pipes->collect_afters();
  $scanned_tag['pipes'] = $pipes;

  return $scanned_tag;
}
add_filter('wpcf7_form_tag', 'dynamic_sessions_field_values', 10, 2);
